/*
 * Decompiled with CFR 0.152.
 */
package com.customer.data;

import com.core.util.filter.Filter;
import com.customer.domain.CustomerMapper;
import com.dto.CustomerDto;
import com.dto.LoginDto;
import com.security.SecurityConstants;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import java.util.List;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class CustomerRepo {
    private final DbConnection dbConnection;

    public int getCustomerCount(Filter customerFilter) {
        String sqlWhere = customerFilter.getFilter();
        String sql = "SELECT COUNT(*) cnt FROM CUSTOMER C WHERE 1 = 1 " + (ConvertStr.isNullOrEmpty((String)sqlWhere) ? "" : "AND " + sqlWhere);
        Integer result = (Integer)this.dbConnection.getJdbcTemplate().queryForObject(sql, Integer.class);
        return result == null ? 0 : result;
    }

    public List<CustomerDto> getCustomers(Filter customerFilter) {
        String sqlWhere = customerFilter.getFilterWithPrecedingWhere();
        LoginDto myLogin = SecurityConstants.loadToken();
        String sql = " SELECT C_Code_C Code, C.C_Name Name, National_Code NationalId, Economic_Code EconomicId, \n        Col_Code_Bed + Moien_Code_Bed + Tafzili_Code_Bed BedSarfasl, \n        Col_Code_Bes + Moien_Code_Bes + Tafzili_Code_Bes BesSarfasl, \n        Kharid IsPurchaser, Forosh IsSeller, inlistsiah IsBlackList, Isnull(Vaseteh,0) IsVaseteh, \n        Isnull(C.Vaseteh_Porsant,0) VasetehPorsant, IsNull(C.Porsant, 0) commission, \n" + (myLogin.getIsTorfehNegar() != false ? "0.0 Mandeh," : "Round(Isnull(Mandeh, 0), 0) Mandeh, \n") + "        Etebar Credit, C_Tel Tel, C_Mobile Mobile, C_Fax Fax, Cust_City City, \n        CityCodeLevy CityCode, Cust_Ostan Ostan, OstanCodeLevy OstanCode, \n        Cust_Mantagheh Mantagheh, Zip_Code ZipCode, C_Address Address, Cust_Job Job, \n        Birth_Date BirthDate, Email_Address Email, C.C_Code ErpCode, WebId, C.C_TYPE [type], \n        C.IsActive [IsActive], FF.F_Date lastSellPrice, FK.F_DATE lastBuyPrice, \n        ISNULL(isSeller, 0) isAmer " + (myLogin.getIsTorfehNegar() != false ? ", 0 vasetehCount" : ", (SELECT count(*) From Customervaseteh where c_code = c.c_code) vasetehCount \n") + (myLogin.getIsMyHoloo() != false ? ", CONVERT(bit, 1) sellerWithTax" : ", sellerWithTax \n") + "       From customer C \n" + (myLogin.getIsTorfehNegar() != false ? "" : "Left join W0_Calc_BedBes_UseInView V on V.c_code=C.c_code \n") + "       LEFT JOIN (SELECT TOP 1 dbo.MiladiToShamsi(FAC_DATE) F_DATE, C_CODE FROM FACTURE \n        WHERE FAC_TYPE = 'F' ORDER BY FAC_DATE DESC) FF on FF.C_CODE = C.C_CODE       LEFT JOIN (SELECT TOP 1 dbo.MiladiToShamsi(FAC_DATE) F_DATE, C_CODE FROM FACTURE \n        WHERE FAC_TYPE = 'K' ORDER BY FAC_DATE DESC) FK on FK.C_CODE = C.C_CODE \n" + sqlWhere;
        return this.dbConnection.getJdbcTemplate().query(sql, (RowMapper)new CustomerMapper());
    }

    public CustomerRepo(DbConnection dbConnection) {
        this.dbConnection = dbConnection;
    }
}

